/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWImportExportOptions;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.export.VWExportGeneralPanel;
import filenet.vw.toolkit.admin.export.VWExportImportTreePanel;
import filenet.vw.toolkit.admin.export.VWExportSummaryPanel;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.dialog.wizard.VWBaseWizardDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class VWExportWizardDialog
extends VWBaseWizardDialog {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    public static final int FUNCTION_IMPORT = 0;
    public static final int FUNCTION_EXPORT = 1;
    private Frame m_parentFrame = null;
    private VWConfigRegionNode m_exportRegionNode = null;
    private int m_nRetStatus = -1;
    private int m_option;
    private boolean m_bIncludeSysConfig = false;
    private boolean m_bIncludeUserInfo = false;
    protected static final int WIDTH = 600;
    protected static final int HEIGHT = 400;
    protected static int MAX_PANEL_INDEX = 3;
    protected static String APP_TITLE = VWResource.ConfigExportDialogTitle;
    protected int m_nPanelIndex = 0;
    protected String m_manifest = null;
    protected VWExportGeneralPanel m_generalPanel = null;
    protected VWExportImportTreePanel m_treePanel = null;
    protected VWExportSummaryPanel m_summaryPanel = null;
    protected String m_summary = null;
    protected boolean m_selectiveExport = false;
    protected VWImportExportOptions m_exportOption = null;

    public VWExportWizardDialog(Frame parent, VWConfigRegionNode bNode) {
        super(parent);
        this.m_parentFrame = parent;
        this.m_exportRegionNode = bNode;
        this.initialize(VWImageLoader.createImageIcon("iso_logon_32.gif"));
        this.m_exportRegionNode.updateExportSelection(2);
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public void releaseResources() {
        if (this.m_generalPanel != null) {
            this.m_generalPanel.releaseResources();
            this.m_generalPanel = null;
        }
        if (this.m_treePanel != null) {
            this.m_treePanel.releaseResources();
            this.m_treePanel = null;
        }
        if (this.m_summaryPanel != null) {
            this.m_summaryPanel.releaseResources();
            this.m_summaryPanel = null;
        }
        this.m_exportRegionNode = null;
    }

    public void windowClosing(WindowEvent event) {
        this.exitApplication();
    }

    protected void addPanels() {
        this.m_panelList = new IVWWizardPanel[MAX_PANEL_INDEX];
        int nPanelIndex = 0;
        this.m_generalPanel = new VWExportGeneralPanel(this, this.m_parentFrame);
        this.m_mainPanel.add((Component)this.m_generalPanel, this.m_generalPanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_generalPanel;
        this.m_treePanel = new VWExportImportTreePanel(this, this);
        this.m_treePanel.init(this.m_exportRegionNode, this.m_parentFrame);
        this.m_mainPanel.add((Component)this.m_treePanel, this.m_treePanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_treePanel;
        this.m_summaryPanel = new VWExportSummaryPanel(this);
        this.m_mainPanel.add((Component)this.m_summaryPanel, this.m_summaryPanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_summaryPanel;
    }

    protected String getDialogDimensionString() {
        return "665,415";
    }

    protected String getDialogTitle() {
        return VWResource.ConfigExportDialogTitle;
    }

    protected String getHelpPage() {
        return VWHelp.Help_Process_Config + "bpfc058.htm#";
    }

    protected boolean performFinishAction() {
        this.exportItems();
        this.m_exportRegionNode.updateExportSelection(2);
        return true;
    }

    public String getExportImportFile() {
        return this.m_generalPanel.getFilePath();
    }

    public void IncludeSysConfig(boolean opt) {
        this.m_bIncludeSysConfig = opt;
    }

    public void IncludeUserInfo(boolean opt) {
        this.m_bIncludeUserInfo = opt;
    }

    public void selectExportOption(int option) {
        this.m_selectiveExport = true;
        this.m_exportRegionNode.updateExportSelection(option);
    }

    public String getManifestFile() {
        return this.m_manifest;
    }

    private long listExportComponents(VWConfigBaseNode aNode) throws Exception {
        long count = 0L;
        if (aNode.isFolderNodeType() || aNode.getExportOptSelection() != 0) {
            boolean bSelected = aNode.getExportOptSelection() == 2;
            int nodeType = aNode.getType();
            if (nodeType == 19) {
                this.m_exportOption.setIncludeRegionProperties(bSelected);
                if (!this.m_selectiveExport) {
                    this.m_exportOption.setInclude(0, "*");
                    this.m_exportOption.setInclude(1, "*");
                    this.m_exportOption.setInclude(2, "*");
                    this.m_exportOption.setInclude(3, "*");
                }
                if (bSelected) {
                    this.m_summary = this.m_summary + VWResource.IncludeRegionProperties + "\r\n";
                }
            } else if (aNode.isFolderNodeType()) {
                this.m_summary = this.m_summary + "\r\n" + VWResource.s_label.toString(aNode.getName()) + "\r\n";
            } else {
                if (this.m_selectiveExport) {
                    switch (nodeType) {
                        case 4: {
                            this.m_exportOption.setInclude(2, aNode.getName());
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: {
                            this.m_exportOption.setInclude(0, aNode.getName());
                            break;
                        }
                        case 3: {
                            this.m_exportOption.setInclude(1, aNode.getName());
                            break;
                        }
                        case 6: {
                            this.m_exportOption.setInclude(3, aNode.getName());
                        }
                    }
                }
                this.m_summary = this.m_summary + "\t" + aNode.getName() + "\r\n";
                ++count;
            }
            for (int i = 0; i < aNode.getChildCount(); ++i) {
                VWConfigBaseNode cNode = (VWConfigBaseNode)aNode.getChildAt(i);
                long k = this.listExportComponents(cNode);
                count += k;
            }
            if (count <= 0L && aNode.isFolderNodeType()) {
                this.m_summary = this.m_summary + "\t" + VWResource.s_none + "\r\n";
            }
        }
        return count;
    }

    private String formManifestFileName() {
        String defaultName = "P8PEExportOptions.xml";
        String s = this.getExportImportFile();
        File f = new File(s);
        String parentDir = null;
        if (!f.isDirectory()) {
            parentDir = f.getParent();
            if (parentDir == null) {
                return "P8PEExportOptions.xml";
            }
        } else {
            parentDir = s;
        }
        return new File(parentDir, "P8PEExportOptions.xml").getAbsolutePath();
    }

    public void exportSummary() {
        try {
            this.m_manifest = this.formManifestFileName();
            this.m_exportOption = VWImportExportOptions.Generate(this.m_manifest);
            this.m_exportOption.setIncludeSystemAdministration(this.m_bIncludeSysConfig);
            this.m_exportOption.setIncludeUserInfo(this.m_bIncludeUserInfo);
            this.m_summary = new String(VWResource.ExportComponentsList.toString(this.m_exportRegionNode.getRouterName()) + "\r\n");
            if (this.m_bIncludeSysConfig) {
                this.m_summary = this.m_summary + VWResource.IncludeSystemProperties + "\r\n";
            }
            if (this.m_bIncludeUserInfo) {
                this.m_summary = this.m_summary + VWResource.IncludeUserInfos + "\r\n";
            }
            this.listExportComponents(this.m_exportRegionNode);
            this.m_summaryPanel.init(this.m_summary, UIManager.getIcon("OptionPane.informationIcon"));
            this.m_exportOption.flush();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportItems() {
        String filePath = this.getExportImportFile();
        IVWtoXML[] apiObjects = null;
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_exportRegionNode.selectExportComponents();
                apiObjects = this.m_exportRegionNode.getIVWtoXMLItems(this.m_bIncludeSysConfig, this.m_bIncludeUserInfo);
                VWXMLConfiguration.exportConfigurationToFile(apiObjects, filePath);
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                VWDebug.logException(ex);
                Object var5_4 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void exitApplication() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int nReply = VWMessageDialog.showConfirmDialog(this, VWResource.CancelMessage, APP_TITLE, 3);
            if (nReply == 2) {
                return;
            }
            this.m_exportRegionNode.updateExportSelection(2);
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

